% 
% Plot Figure 7-2 to 7-7 in the book
%
% Dongrui WU (dongruiw@usc.edu), 5/5/2008

clc
clear all
close all

%% Read Data for Figure 7-2
[A,words] = xlsread('data72.xls');
words=words(1,1:2:end);
[row, col] = size(A);
MFs=zeros(col/2,9);
Cs=zeros(col/2,1);
for i=1:col/2
    L = A(1:row, 2*i-1);  %% Left end-points for interval data.
    R = A(1:row, 2*i);    %% Right end-points for interval data.
    MFs(i,:) = IA(L,R); %% Map into an IT2 FS
    Cs(i)=centroidIT2(MFs(i,:)); %% Compute the centroid
end
[Cs,index]=sort(Cs);  % Sort the centers of the centroids
MFs=MFs(index,:);
words=words(index); % Reorder the names of words
% exchange "none to very little" and "extremely low"
MFs(1:2,:)=MFs([2 1],:);
words(1:2)=words([2 1]);
Cs(1:2)=Cs([2 1]);
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
for i=1:col/2
    subplot(6,4,1*floor((i-1)/3)+i);
    plotIT2(MFs(i,:));
    title(words(i),'fontsize',10);
    set(gca,'YTick',[]);
    set(gca,'XTick',[]);
    axis([0 10 0 1]);
end
saveas(gcf,'Fig7-2.eps');

%% Read Data for Figure 7-3
[A,words] = xlsread('data73.xls');
words=words(1,1:2:end);
[row, col] = size(A);
MFs=zeros(col/2,9);
Cs=zeros(col/2,1);
for i=1:col/2
    L = A(1:row, 2*i-1);  %% Left end-points for interval data.
    R = A(1:row, 2*i);    %% Right end-points for interval data.
    MFs(i,:) = IA(L,R); %% Map into an IT2 FS
    Cs(i)=centroidIT2(MFs(i,:)); %% Compute the centroid
end
[Cs,index]=sort(Cs);  % Sort the centers of the centroids
MFs=MFs(index,:);
words=words(index); % Reorder the names of words
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
for i=1:col/2
    subplot(6,4,1*floor((i-1)/3)+i);
    plotIT2(MFs(i,:));
    title(words(i),'fontsize',10);
    set(gca,'YTick',[]);
    set(gca,'XTick',[]);
    axis([0 10 0 1]);
end
saveas(gcf,'Fig7-3.eps');

%% Read Data for Figure 7-4
[A,words] = xlsread('data74.xls');
words=words(1,1:2:end);
[row, col] = size(A);
MFs=zeros(col/2,9);
Cs=zeros(col/2,1);
for i=1:col/2
    L = A(1:row, 2*i-1);  %% Left end-points for interval data.
    R = A(1:row, 2*i);    %% Right end-points for interval data.
    MFs(i,:) = IA(L,R); %% Map into an IT2 FS
    Cs(i)=centroidIT2(MFs(i,:)); %% Compute the centroid
end
[Cs,index]=sort(Cs);  % Sort the centers of the centroids
MFs=MFs(index,:);
words=words(index); % Reorder the names of words
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
for i=1:col/2
    subplot(6,4,1*floor((i-1)/3)+i);
    plotIT2(MFs(i,:));
    title(words(i),'fontsize',10);
    set(gca,'YTick',[]);
    set(gca,'XTick',[]);
    axis([0 10 0 1]);
end
saveas(gcf,'Fig7-4.eps');

%% Read Data for Figure 7-5
[A,words] = xlsread('data75.xls');
words=words(1,1:2:end);
[row, col] = size(A);
MFs=zeros(col/2,9);
Cs=zeros(col/2,1);
for i=1:col/2
    L = A(1:row, 2*i-1);  %% Left end-points for interval data.
    R = A(1:row, 2*i);    %% Right end-points for interval data.
    MFs(i,:) = IA(L,R); %% Map into an IT2 FS
    Cs(i)=centroidIT2(MFs(i,:)); %% Compute the centroid
end
[Cs,index]=sort(Cs);  % Sort the centers of the centroids
MFs=MFs(index,:);
words=words(index); % Reorder the names of words
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
for i=1:col/2
    subplot(6,4,1*floor((i-1)/3)+i);
    plotIT2(MFs(i,:));
    title(words(i),'fontsize',10);
    set(gca,'YTick',[]);
    set(gca,'XTick',[]);
    axis([0 10 0 1]);
end
saveas(gcf,'Fig7-5.eps');

%% Read Data for Figure 7-6
[A,words] = xlsread('data76.xls');
words=words(1,1:2:end);
[row, col] = size(A);
MFs=zeros(col/2,9);
Cs=zeros(col/2,1);
for i=1:col/2
    L = A(1:row, 2*i-1);  %% Left end-points for interval data.
    R = A(1:row, 2*i);    %% Right end-points for interval data.
    MFs(i,:) = IA(L,R); %% Map into an IT2 FS
    Cs(i)=centroidIT2(MFs(i,:)); %% Compute the centroid
end
[Cs,index]=sort(Cs);  % Sort the centers of the centroids
MFs=MFs(index,:);
words=words(index); % Reorder the names of words
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
for i=1:col/2
    subplot(6,4,1*floor((i-1)/3)+i);
    plotIT2(MFs(i,:));
    title(words(i),'fontsize',10);
    set(gca,'YTick',[]);
    set(gca,'XTick',[]);
    axis([0 10 0 1]);
end
saveas(gcf,'Fig7-6.eps');

%% Read Data for Figure 7-7
[A,words] = xlsread('data77.xls');
words=words(1,1:2:end);
[row, col] = size(A);
MFs=zeros(col/2,9);
Cs=zeros(col/2,1);
for i=1:col/2
    L = A(1:row, 2*i-1);  %% Left end-points for interval data.
    R = A(1:row, 2*i);    %% Right end-points for interval data.
    MFs(i,:) = IA(L,R); %% Map into an IT2 FS
    Cs(i)=centroidIT2(MFs(i,:)); %% Compute the centroid
end
[Cs,index]=sort(Cs);  % Sort the centers of the centroids
MFs=MFs(index,:);
words=words(index); % Reorder the names of words
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
for i=1:col/2
    subplot(6,4,1*floor((i-1)/3)+i);
    plotIT2(MFs(i,:));
    title(words(i),'fontsize',10);
    set(gca,'YTick',[]);
    set(gca,'XTick',[]);
    axis([0 10 0 1]);
end
saveas(gcf,'Fig7-7.eps');